#!/bin/sh

CWD=`pwd`

LIBDIR=/usr/lib
LIBOBJDIR=$CWD/OpenBSD/lib/libc
LIBFILES="\
libc.a libc_p.a libc_pic.a \
libc.so.30.3 \
"

INCDIR=/usr/include
INCOBJDIR=$CWD/OpenBSD/include
INCFILES="assert.h ctype.h iconv.h langinfo.h locale.h paths.h stddef.h stdlib.h wchar.h wctype.h"

INCSYSDIR=/usr/include/sys
INCSYSOBJDIR=$CWD/OpenBSD/sys/sys
INCSYSFILES="cdefs.h endian.h errno.h featuretest.h localedef.h"

do_install () {
    destdir=$1
    srcdir=$2
    shift 2
    cd $srcdir
    cp -f $* $destdir
}

do_install $LIBDIR $LIBOBJDIR $LIBFILES
do_install $INCDIR $INCOBJDIR $INCFILES
do_install $INCSYSDIR $INCSYSOBJDIR $INCSYSFILES

ARCH=`/usr/bin/uname -m`
INCARCHDIR=/usr/include/$ARCH
INCARCHOBJDIR=$CWD/OpenBSD/sys/arch/$ARCH/include
INCARCHFILES="ansi.h limits.h types.h"

do_install $INCARCHDIR $INCARCHOBJDIR $INCARCHFILES
