#!/bin/sh

REL=`/usr/bin/uname -r`
ARCH=`/usr/bin/uname -m`

BUDIR=$REL-dist
LIBDIR=/usr/lib
LIBBUDIR=$LIBDIR/$BUDIR

LIBFILES="\
libc.a libc_p.a libc_pic.a \
libc.so.30.3 \
"

INCDIR=/usr/include
INCBUDIR=$INCDIR/$BUDIR
INCFILES="assert.h ctype.h langinfo.h locale.h paths.h stddef.h stdlib.h"

INCSYSDIR=/usr/include/sys
INCSYSBUDIR=$INCBUDIR/sys
INCSYSFILES="cdefs.h endian.h errno.h localedef.h"

INCARCHDIR=/usr/include/$ARCH
INCARCHBUDIR=$INCBUDIR/$ARCH
INCARCHFILES="ansi.h limits.h types.h"

do_bu () {
   origdir=$1
   budir=$2
   if [ -d $budir ]; then
      echo $budir already exists.
   else
      mkdir $budir
      cd $origdir
      shift 2
      mv -f $* $budir
   fi
}

do_bu $LIBDIR $LIBBUDIR $LIBFILES
do_bu $INCDIR $INCBUDIR $INCFILES
do_bu $INCSYSDIR $INCSYSBUDIR $INCSYSFILES
do_bu $INCARCHDIR $INCARCHBUDIR $INCARCHFILES
